"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const wp = require("whatsapp-web.js");
const Client = wp.Client;
const LocalAuth = wp.LocalAuth;
const qrcode = __importStar(require("qrcode-terminal"));
const qrcode_1 = __importDefault(require("qrcode"));
const openai_simple_1 = require("./openai-simple");
const gemini_adapter_1 = require("./gemini-adapter");
const dotenv_1 = __importDefault(require("dotenv"));
const express_1 = __importDefault(require("express"));
const http_1 = require("http");
const socket_io_1 = require("socket.io");
const path_1 = __importDefault(require("path"));
const fs_1 = __importDefault(require("fs"));
// Carrega variáveis de ambiente
dotenv_1.default.config();
// Configuração do Servidor Web
const app = (0, express_1.default)();
const httpServer = (0, http_1.createServer)(app);
const io = new socket_io_1.Server(httpServer);
const PORT = process.env.PORT || 3000;
// Serve arquivos estáticos (Ajuste para funcionar tanto em Dev quanto em Prod/Dist)
const publicPath = path_1.default.join(__dirname, 'public');
// Se não achar no dist, tenta na raiz (para dev)
if (!fs_1.default.existsSync(publicPath)) {
    app.use(express_1.default.static(path_1.default.join(__dirname, '../public')));
}
else {
    app.use(express_1.default.static(publicPath));
}
app.use(express_1.default.json());
// Endpoint de Configuração Inicial (Licença + API Key)
app.post('/configure', (req, res) => {
    const { licenseKey, apiKey, companyName } = req.body;
    // Salva no .env (para o sistema)
    let envContent = `PORT=3000\n`;
    if (apiKey)
        envContent += `GEMINI_API_KEY=${apiKey}\n`;
    fs_1.default.writeFileSync(path_1.default.join(__dirname, '../.env'), envContent);
    // Salva no JSON de configuração
    const configPath = path_1.default.join(__dirname, '../config/client_settings.json');
    const configData = {
        license_key: licenseKey || "DEMO-MODE",
        gemini_api_key: apiKey || "",
        company_name: companyName || "Minha Empresa"
    };
    fs_1.default.writeFileSync(configPath, JSON.stringify(configData, null, 2));
    // Recarrega configuração na memória
    (0, gemini_adapter_1.reloadConfiguration)();
    res.json({ success: true, message: "OrionBot configurado com sucesso!" });
});
const client = new Client({
    authStrategy: new LocalAuth({ dataPath: './session' }),
    puppeteer: {
        headless: true,
        args: ['--no-sandbox', '--disable-setuid-sandbox', '--disable-gpu']
    },
    webVersionCache: {
        type: 'remote',
        remotePath: 'https://raw.githubusercontent.com/wppconnect-team/wa-version/main/html/2.2412.54.html'
    }
});
httpServer.listen(PORT, () => {
    console.log(`🌐 OrionBot Client rodando na porta ${PORT}`);
    console.log(`🔗 Interface de Gestão: http://localhost:${PORT}`);
});
io.on('connection', (socket) => {
    socket.emit('status', 'Aguardando Leitura do QR Code...');
});
const conversationHistory = new Map();
async function processMessage(message) {
    try {
        const chatId = message.from;
        const messageText = message.body;
        const contactName = message._data?.notifyName || "Cliente";
        if (message.fromMe)
            return;
        if (message.from.includes('@g.us'))
            return; // Ignora grupos por padrão
        let history = conversationHistory.get(chatId) || [];
        history = (0, openai_simple_1.limitConversationHistory)(history, 20);
        history.push({ role: "user", content: messageText });
        const context = (0, openai_simple_1.createConversationContext)(chatId, contactName, message.type, message.from.includes('@g.us'));
        let response;
        // Suporte a Áudio (Multimodal)
        if (message.hasMedia && (message.type === 'ptt' || message.type === 'audio')) {
            console.log(`🎤 Áudio recebido de ${contactName}`);
            try {
                const media = await message.downloadMedia();
                if (media) {
                    response = await (0, gemini_adapter_1.sendMessageToGemini)(messageText || "", context, history, { mimeType: media.mimetype, data: media.data });
                }
                else {
                    response = { success: false, text: "Erro na recepção do áudio." };
                }
            }
            catch (e) {
                console.error("Erro audio:", e);
                response = { success: false, text: "Não entendi o áudio." };
            }
        }
        else {
            response = await (0, gemini_adapter_1.sendMessageToGemini)(messageText, context, history);
        }
        if (response.success) {
            history.push({ role: "assistant", content: response.text });
            conversationHistory.set(chatId, history);
            await message.reply(response.text);
        }
    }
    catch (error) {
        console.error('Erro processMessage:', error);
    }
}
async function handleSpecialCommands(message) {
    const text = message.body.toLowerCase().trim();
    if (text === '!reset' || text === '!limpar') {
        conversationHistory.delete(message.from);
        await message.reply('✅ Memória da conversa limpa.');
        return true;
    }
    if (text === '!update' || text === '!atualizar') {
        (0, gemini_adapter_1.reloadConfiguration)();
        await message.reply('🔄 Configurações e Cérebro recarregados da nuvem.');
        return true;
    }
    return false;
}
client.once('ready', () => {
    console.log('✅ OrionBot Client Conectado ao WhatsApp!');
    io.emit('ready', true);
    io.emit('status', 'Online e Operando');
});
client.on('qr', (qr) => {
    qrcode.generate(qr, { small: true });
    qrcode_1.default.toDataURL(qr, (err, url) => {
        if (!err) {
            io.emit('qr', url);
            io.emit('status', 'Escaneie o QR Code');
        }
    });
});
client.on('message_create', async (message) => {
    if (!await handleSpecialCommands(message)) {
        await processMessage(message);
    }
});
client.initialize();
