"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createConversationContext = createConversationContext;
exports.limitConversationHistory = limitConversationHistory;
exports.clearChatSession = clearChatSession;
exports.getSessionStats = getSessionStats;
function createConversationContext(chatId, contactName, messageType, isGroup = false) {
    return {
        chatId,
        contactName,
        isGroup,
        platform: "whatsapp",
        timestamp: new Date().toISOString(),
        messageType
    };
}
function limitConversationHistory(history, limit = 20) {
    if (history.length <= limit)
        return history;
    // Mantém sempre as ultimas mensagens e pode ser expandido para manter system prompt no inicio se estivesse aqui
    return history.slice(-limit);
}
const chatSessions = new Map();
function clearChatSession(chatId) {
    chatSessions.delete(chatId);
}
function getSessionStats() {
    return {
        total: chatSessions.size,
        sessions: Array.from(chatSessions.entries()).map(([k, v]) => ({ chatId: k, sessionId: v.sessionId || 'N/A' }))
    };
}
