
export interface ConversationMessage {
    role: "user" | "assistant" | "system";
    content: string;
}

export interface WhatsappContext {
    chatId: string;
    contactName: string;
    isGroup: boolean;
    platform: "whatsapp";
    timestamp: string;
    messageType: string;
}

export function createConversationContext(
    chatId: string,
    contactName: string,
    messageType: string,
    isGroup: boolean = false
): WhatsappContext {
    return {
        chatId,
        contactName,
        isGroup,
        platform: "whatsapp",
        timestamp: new Date().toISOString(),
        messageType
    };
}

export function limitConversationHistory(
    history: ConversationMessage[],
    limit: number = 20
): ConversationMessage[] {
    if (history.length <= limit) return history;
    // Mantém sempre as ultimas mensagens e pode ser expandido para manter system prompt no inicio se estivesse aqui
    return history.slice(-limit);
}

const chatSessions = new Map<string, any>();

export function clearChatSession(chatId: string) {
    chatSessions.delete(chatId);
}

export function getSessionStats() {
    return {
        total: chatSessions.size,
        sessions: Array.from(chatSessions.entries()).map(([k, v]) => ({ chatId: k, sessionId: v.sessionId || 'N/A' }))
    };
}
