-- Tabela de Licenças do OrionBot
create table public.bot_licenses (
  id uuid not null default gen_random_uuid (),
  created_at timestamp with time zone not null default now(),
  company_name text not null,
  license_code text not null,
  system_prompt text not null, -- O Cérebro da IA
  is_active boolean not null default true,
  contact_email text null,
  constraint bot_licenses_pkey primary key (id),
  constraint bot_licenses_license_code_key unique (license_code)
);

-- Habilitar RLS
alter table public.bot_licenses enable row level security;

-- Políticas de Acesso
-- 1. Leitura Pública (apenas para validar licença via código) - Na prática, melhor fazer via Edge Function para não expor tudo
-- Mas para MVP, permitimos leitura se souber o código.
create policy "Leitura de Licença por Código"
on public.bot_licenses
for select
using (true); 

-- 2. Escrita Apenas Admin (Você)
-- Assumindo que você usará o painel admin logado.
create policy "Admin Total"
on public.bot_licenses
for all
to authenticated
using (auth.email() = 'deniantodde57@gmail.com');
